import { Link, useLocation } from 'react-router-dom'
import { Languages, Phone, Mail, MapPin, Clock } from 'lucide-react'
import { motion } from 'framer-motion'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app">
      <motion.header 
        className="header"
        initial={{ y: -100 }}
        animate={{ y: 0 }}
        transition={{ type: "spring", stiffness: 120, damping: 14, duration: 0.5 }}
      >
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <Languages className="logo-icon" size={36} strokeWidth={2.5} />
              <span className="logo-text">LangMaster</span>
            </Link>
            <nav className="nav">
              <Link to="/" className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}>
                Мои курсы
              </Link>
              <Link to="/enroll" className={`nav-link ${location.pathname === '/enroll' ? 'active' : ''}`}>
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </motion.header>

      <main className="main">
        <div className="container">
          {children}
        </div>
      </main>

      <motion.footer 
        className="footer"
        initial={{ y: 100 }}
        animate={{ y: 0 }}
        transition={{ type: "spring", stiffness: 120, damping: 14, delay: 0.2, duration: 0.5 }}
      >
        <div className="container">
          <div className="footer-content">
            <div className="footer-section">
              <div className="footer-logo">
                <Languages className="footer-logo-icon" size={32} strokeWidth={2.5} />
                <h2>LangMaster</h2>
              </div>
              <p className="footer-description">
                Профессиональные онлайн-курсы по иностранным языкам с опытными преподавателями
              </p>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Контакты</h3>
              <ul className="footer-links">
                <li><Phone size={18} strokeWidth={1.5} /> Телефон: <a href="tel:+79991234567">+7 (999) 123-45-67</a></li>
                <li><Mail size={18} strokeWidth={1.5} /> Email: <a href="mailto:info@langmaster.ru">info@langmaster.ru</a></li>
                <li><MapPin size={18} strokeWidth={1.5} /> Адрес: ул. Языковая, 5, Москва</li>
              </ul>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Режим работы</h3>
              <ul className="footer-links">
                <li><Clock size={18} strokeWidth={1.5} /> Пн-Пт: 9:00 - 21:00</li>
                <li><Clock size={18} strokeWidth={1.5} /> Сб-Вс: 10:00 - 18:00</li>
              </ul>
            </div>
          </div>
          <div className="footer-bottom">
            &copy; 2025 LangMaster. Все права защищены.
          </div>
        </div>
      </motion.footer>
    </div>
  )
}

export default Layout

